<!DOCTYPE HTML>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Admin</title>
<link href="../css/style.css" rel="stylesheet" type="text/css">
<!--[if lte IE 6]>
<link rel="stylesheet" href="css/ie-fixes.css" type="text/css" />
<![endif]-->
<!--[if lte IE 7]>
<link rel="stylesheet" href="css/ie-fixes.css" type="text/css" />
<![endif]-->
<!--[if lte IE 8]>
<link rel="stylesheet" href="css/ie-fixes.css" type="text/css" />
<![endif]-->
</head>
<body>
<div class="baseball_field">
  <div id="base_1"></div>
  <div id="base_2"></div>
  <div id="base_3"></div>
  <div id="base_4"></div>
</div>
<table width="50%" border="0" cellpadding="2">
  <tr>
    <th scope="row">S</th>
    <td><div id="s_1"></div></td>
    <td><div id="s_2"></div></td>
    <td><div id="s_3"></div></td>
  </tr>
  <tr>
    <th scope="row">B</th>
    <td><div id="b_1"></div></td>
    <td><div id="b_2"></div></td>
    <td><div id="b_3"></div></td>
    <td><div id="b_4"></div></td>
  </tr>
  <tr>
    <th scope="row">O</th>
    <td><div id="o_1"></div></td>
    <td><div id="o_2"></div></td>
    <td><div id="o_3"></div></td>
  </tr>
</table>
<form id="score">
<table width="50%" border="0" cellpadding="2">
  <tr>
    <th scope="row">Team</th>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
    <td>&nbsp;</td>
  </tr>
  <tr>
    <th scope="row">SL</th>
    <td><input id="team_1_s_1" type="text" size="2" maxlength="3"></td>
    <td><input id="team_1_s_2" type="text" size="2" maxlength="3"></td>
    <td><input id="team_1_s_3" type="text" size="2" maxlength="3"></td>
    <td><input id="team_1_s_4" type="text" size="2" maxlength="3"></td>
    <td><input id="team_1_s_5" type="text" size="2" maxlength="3"></td>
    <td><input id="team_1_s_6" type="text" size="2" maxlength="3"></td>
    <td><input id="team_1_s_7" type="text" size="2" maxlength="3"></td>
    <td><input id="team_1_s_8" type="text" size="2" maxlength="3"></td>
    <td><input id="team_1_s_9" type="text" size="2" maxlength="3"></td>
    <td><input id="team_1_s_10" type="text" size="2" maxlength="3"></td>
  </tr>
  <tr>
    <th scope="row">PAK</th>
    <td><input id="team_2_s_1" type="text" size="2" maxlength="3"></td>
    <td><input id="team_2_s_2" type="text" size="2" maxlength="3"></td>
    <td><input id="team_2_s_3" type="text" size="2" maxlength="3"></td>
    <td><input id="team_2_s_4" type="text" size="2" maxlength="3"></td>
    <td><input id="team_2_s_5" type="text" size="2" maxlength="3"></td>
    <td><input id="team_2_s_6" type="text" size="2" maxlength="3"></td>
    <td><input id="team_2_s_7" type="text" size="2" maxlength="3"></td>
    <td><input id="team_2_s_8" type="text" size="2" maxlength="3"></td>
    <td><input id="team_2_s_9" type="text" size="2" maxlength="3"></td>
    <td><input id="team_2_s_10" type="text" size="2" maxlength="3"></td>
    <td><input type="button" id="reset_score" value="Reset Score">
  </tr>
</table>
</form>
</body>
<script src="../js/jquery.js"></script>
<script src="../js/script_admin.js"></script>
<script>
$(document).ready(function() {
	$.post("../db/db.php", 
		{
			get_base_status: 'okay',
		},
		function(data) {
			data = data.split("~");
			set_base_status(data);
		}
	);
	
	$.post("../db/db.php", 
		{
			get_s_b_o_status: 'okay'
		},
	
		function(data) {
			data = data.split("~");
			set_s_b_o_status(data);
		}
	);
	
	$.post("../db/db.php", 
		{
			get_score_status: 'okay'
		},
	
		function(data) {
			data = data.split("~");
			set_score_status(data);
		}
	);
	
	$('div').click(
		function(e) {
			e.stopPropagation();
			id = this.id;
			id_length = id.length;
			value = 0;
			
			table = '';
			if(id_length==6){
				table = 'base';
				if(this.className == 'base')
					value = 1;
			}
			if(id_length==3){
				table = 's_b_o';
				if(this.className == 's_b_o')
					value = 1;
			}
			
			if(table !== ''){
				$.post("../db/db.php", 
					{
						id: id,
						value: value,
						table: table
					},
					function(data) {
						data = data.split("~");
						if(table === 'base')
							set_base_status(data);
						if(table === 's_b_o')
							set_s_b_o_status(data);
					}
				);	
			}
		}
	);
	
	$("input:text").focus(function(){
		$(this).one('mouseup', function(event){
			event.preventDefault();
		}).select();
	});
	
	$('input:text').keyup(
		function() {
			this.value = this.value.replace(/[^0-9\.]/g,'');
			
			id = this.id;
			value = this.value;
			table = 'score';
			
			$.post("../db/db.php", 
				{
					id: id,
					value: value,
					table: table
				},
				function(data) {
					data = data.split("~");
					set_score_status(data);
				}
			);	
		}
	);
	
	$( "#reset_score" ).click(function() {
		$.post("../db/db.php", 
				{
					reset_score: 'okay',
				},
				function(data) {
					data = data.split("~");
					set_score_status(data);
				}
			);
	});

});
</script>
</html>